rm(list=objects())
setwd("C:/Users/clment/Downloads/optimality_of_variational_infe-Supplementary Material/Supplementary Materials/Numerical experiments/Simulations/Results")

type <- 3
path <- "Missclassified"

# Load results
if(type == 1){
  path <- paste0(path, "/Assortative SBM")
}else if(type == 2){
  path <- paste0(path, "/Disassortative SBM")
}else{
  path <- paste0(path, "/Mixed SBM")
}


N_list <- round(exp(seq(log(50), log(1000), length.out = 10)))
M <- 100 # number of experiments

# record the errors 
Missclassified <- matrix(NA, ncol = 3, nrow = 10)
Missclassified_prop <- matrix(NA, ncol = 3, nrow = 10)

for (n in 1:10){
  N <- N_list[n]
  res <- readRDS(paste0(path, "/N_", N,".RDS"))
  Missclassified[n,] <- quantile(res$Prop_Error_Z, probs = c(0.25, 0.5, 0.75))*res$N
  Missclassified_prop[n,] <- quantile(res$Prop_Error_Z, probs = c(0.25, 0.5, 0.75))
}


plot(x = N_list, y = Missclassified_prop[,2], type = 'l', col = 'black', 
     xlab = "Number of nodes", ylab = "Error", log = "x", ylim = c(0,1))
lines(x = N_list, y = Missclassified_prop[,1], lty = 3, col = 'black')
lines(x = N_list, y = Missclassified_prop[,3], lty = 3, col = 'black')


plot(x = N_list, y = Missclassified[,2], type = 'l', col = 'black', 
     xlab = "Number of nodes", ylab = "Error", log = "x", ylim = c(0,40))
lines(x = N_list, y = Missclassified[,1], lty = 3, col = 'black')
lines(x = N_list, y = Missclassified[,3], lty = 3, col = 'black')

